within BuildingControlLib.BuildingControl.VDI3813.ApplicationFunctions.Internal;
block FunctionSelectionFunctionality
  "Algorithm model to provide functionality of FunctionSelection"
  extends
    BuildingControlLib.BuildingControl.VDI3813.Interfaces.Partial.PartialFunctionality;

  /***   ***   ***   ***   ***   ***   ***   ***   ***   ***/
  // Connectors
  Interfaces.ControlFunctionAirTemperatureInput
    F_BMS "Control function for air temperature control that is generated by time schedule of the operator." annotation (Placement(transformation(extent={{-100,40},{-80,60}})));
  Interfaces.BooleanInput B_DEW "Measured value that shows if dewpoint has been reached."
    annotation (Placement(transformation(extent={{-100,20},{-80,40}})));
  Interfaces.RealInput T_ROOM "Measured room air temperature."
    annotation (Placement(transformation(extent={{-100,-20},{-80,0}})));
  Interfaces.RealInput T_SETPTS[8] "Array of temperature setpoints for heating and cooling of all energy modes."
    annotation (Placement(transformation(extent={{-100,-40},{-80,-20}})));
  Interfaces.ControlFunctionAirTemperatureOutput
    F_ACT "Valid room air temperature control function." annotation (Placement(transformation(extent={{100,-10},{120,10}})));
  /***   ***   ***   ***   ***   ***   ***   ***   ***   ***/
  // Variables
  Modelica.SIunits.Temperature T_ZE( start = 273.15 + 20);

algorithm
  T_ZE := (T_SETPTS[4] + T_SETPTS[5])/2;
  if F_BMS == CFAT.off or F_BMS == CFAT.heating or F_BMS == CFAT.nightcool then
    F_ACT := F_BMS;
  else
    if F_BMS == CFAT.cooling or F_BMS == CFAT.precool then
      if B_DEW then
        F_ACT := CFAT.off;
      else
        F_ACT := F_BMS;
      end if;
    elseif F_BMS == CFAT.auto then
      if T_ROOM <= T_ZE then
        F_ACT := CFAT.heating;
        else
          if B_DEW then
            F_ACT := CFAT.off;
          else
            F_ACT := CFAT.cooling;
        end if;
      end if;
    end if;
  end if;

  annotation (preferedView="Info",Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
            -100},{100,100}}), graphics), Documentation(info="<html>
<h4><span style=\"color:#008000\">Overview</span></h4>
<p>Block that implements functionality of &QUOT;Function selection&QUOT; from VDI 3813 <a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.5.22, p. 70 - 72]</a>. </p>
<h4><span style=\"color:#008000\">Functional Description</span></h4>
<p>&QUOT;The room climate can be influenced by various control functions (see Figure 44) (RA-FL section 6, column 21; informative function block Figure 45), which can either be specified by the operator or determined automatically depending on specific states. Based on the currently selected control function, the application functions <i>Room supply air temperature cascade control</i>, <i>Room temperature control</i>, <i>Fan control</i> and <i>Night-time cooling</i> can decide whether to be active or not. The following control functions are selectable:</p>
<p>OFF: control inactive</p>
<p>AUTO: control active with automatic changeover between heating and cooling modes</p>
<p>HEATING: control active in heating mode</p>
<p>COOLING: control active in cooling mode</p>
<p>PRECOOL: control active in cooling mode, but using comfort setpoint for heating</p>
<p>NIGHTCOOL: only night-time cooling active</p>
<p>Apart from the selection of a control function by the operator (e. g. via a time program), a change of function can also be triggered by the dewpoint being reached in cooling mode. In this case, the controller remains inactive (OFF). If automatic room-by-room changeover between heating and cooling is permissible (e. g. with four-pipe systems), and is selected by the operator (F_BMS = AUTO), the function decides on changing the active function (HEATING or COOLING) depending on the current setpoints (T_SETPT) and the room temperature (T_ROOM). In doing so, the function must make sure that, for systems having just one joint register or one joint area for heating and cooling purposes, changeover takes place via the OFF function, after an appropriate holding time to allow any open valves to close.&QUOT;<a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.5.22, p. 70 - 72]</a></p>
<p><br>Implementation of the functionality of function selection. Assumption is made that T_ZE (Temperature in the middle between comfort setpoints) is the arithmetic mean of the cooling and heating set points.</p>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>
<td></td>
</tr>
</table>
<p><br><br><br><br><b>Fig. 1: </b>UML activity diagram of the application function <i>Function selection, </i><a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.5.22, p. 70 - 72]</a></p>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>
<td><p><img src=\"modelica://BuildingControlLib/Resources/Images/docUMLAkt_FunctionSelection.PNG\"/> </p></td>
</tr>
</table>
</html>", revisions="<html>
<ul>
<li>March 07, 2017&nbsp; by Georg Ferdinand Schneider &amp; Georg Ambrosius Pe&szlig;ler:<br>Implemented.</li>
</ul>
</html>
"));
end FunctionSelectionFunctionality;
